/*------------------------------------------------------------------------------*
 * File Name: FFWFunctionOrganizer.h											*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Jasmine 06/21/10 ORG-343 QUICK_CHECK_FUNCTION_BODY							*
 *	Jasmine 06/22/10 ORG-2-S2 WANT_DESTINATION_PATH								*
 *	Jasmine 06/23/10 ORG-2-S4 FUNCTION_WIZARD_ALLOW_USER_DEFINED_FUNC_CHANGE_FORM*
 *	Folger 06/24/10 ORG-390-P4 SHOW_CONSTANTS_IN_EVALUATION_PAGE				*
 *	Folger 06/25/10 ORG-390-P2 SAVE_USER_CHANGED_IN_FIT_FUNCTION_WIZARD_INTO_FDF*
 *	Folger 07/05/10 ORG-478-S1 ERROR_CHECKING_FOR_EXPRESSION_MULTIPLE_DEPENDENTS*
 *	Folger 09/06/2010 ORG-958-P5 FAIED_TO_SAVE_FDF_NAME_NEW_FUNCION_IN_FFW_OPEN_FROM_FO
 *------------------------------------------------------------------------------*/

#ifndef _FFWFUNCTIONORGANIZER_H
#define _FFWFUNCTIONORGANIZER_H

#include "NLFitSession.h"
#include "NumFunctionOrganizer.h"

/*------------------------------------------------------------------------------*
 * FFWFunctionOrganizer		 													*
 *------------------------------------------------------------------------------*/

class FFWFunctionOrganizer
{
public:
	///------ Folger 09/06/2010 ORG-958-P5 FAIED_TO_SAVE_FDF_NAME_NEW_FUNCION_IN_FFW_OPEN_FROM_FO
	FFWFunctionOrganizer(NumFunctionOrganizer* pNFO = NULL);
	~FFWFunctionOrganizer();
	///------ End FAIED_TO_SAVE_FDF_NAME_NEW_FUNCION_IN_FFW_OPEN_FROM_FO

private:
	///------ Folger 09/06/2010 ORG-958-P5 FAIED_TO_SAVE_FDF_NAME_NEW_FUNCION_IN_FFW_OPEN_FROM_FO
	//NumFunctionOrganizer 	m_NFO;
	NumFunctionOrganizer* 	m_pNFO;
	///------ End FAIED_TO_SAVE_FDF_NAME_NEW_FUNCION_IN_FFW_OPEN_FROM_FO
	BOOL					m_bOwner;

	Tree					m_trCategoryFunction;

public:

	// Category
	void GetCategoryList(TreeNode & trCategory);
	int GetFunctionList(const string & strCategoryName, vector<string> & vsFunctions);
	bool NewCategory(const string & strCategoryName);

	bool NewFunction(TreeNode & trNewFunction, string strFunctionName);
	string GetCategoryDefaultFunction(const string & strCategoryName);

	bool IsCategoryExist(const string & strCategoryExist);

	// Function
	bool LoadFunction(const string & strCategoryName, const string & strFunctionName, TreeNode & trFunction);
	///Sophy 6/29/2010 ORG-432-S4 SHOW_FUNCTION_NAME_ON_FFW_DIALOG_TITLE
	bool IsSysFunction(TreeNode tr){return m_pNFO->IsSysFunction(tr);}
	///end SHOW_FUNCTION_NAME_ON_FFW_DIALOG_TITLE
	///Sophy 7/5/2010 ORG-432-P4 INIT_PARAMS_VALUES_WHEN_CREATE_USER_DEF_FUNCTION
	bool IsFunctionExist(const TreeNode& trFunction);
	///end INIT_PARAMS_VALUES_WHEN_CREATE_USER_DEF_FUNCTION
	
	string CreateNewFunctionName(string strAttribute, string strPrefix, string strPostfix);
	bool   CheckFuncName(string & strFuncName, TreeNode trParent, bool bCorrect, string * pStrError);

	string FindFunctionCategory(const string & strFunctionName);

	///Jasmine 06/22/10 ORG-2-S2 WANT_DESTINATION_PATH
	bool SaveFunction(TreeNode & trFunction, string* pstrErr = NULL, string* pstrDestinationFile = NULL);
	///End WANT_DESTINATION_PATH

	// General Information
	string GetFunctionName(TreeNode & trFunction);
	void SetFunctionName(const string & strName, TreeNode & trFunction);

	string GetDescription(TreeNode & trFunction);
	void SetDescription(const string & strDescription, TreeNode & trFunction);

	string GetSource(TreeNode & trFunction);
	void SetSource(const string & strSource, TreeNode & trFunction);

	string GetType(TreeNode & trFunction);
	void SetType(const string & strType, TreeNode & trFunction);

	string GetForm(TreeNode & trFunction);
	void SetForm(const string & strForm, TreeNode & trFunction);

	bool IsDerivative(TreeNode & trFunction);
	void SetDerivative(bool bDerivative, TreeNode & trFunction);

	// Fitting parameters
	string GetFittingPara(TreeNode & trFunction);
	void SetFittingPara(const string & strNames, TreeNode & trFunction);
	///Jasmine 06/21/10 ORG-343 QUICK_CHECK_FUNCTION_BODY
	string GetFittingParamWithValue(TreeNode & trFunction, char chDelimiter);
	int ParseFittingParamValue(vector& vParamValue, const TreeNode& trFunction, LPCSTR lpcszParamVal, char chDelimiter);
	///End QUICK_CHECK_FUNCTION_BODY

	string GetParaUnits(TreeNode & trFunction);
	void SetParaUnits(const string & strUnits, TreeNode & trFunction);

	string GetParaMeanings(TreeNode & trFunction);
	void SetParaMeanings(const string & strMeanings, TreeNode & trFunction);

	string GetParaValues(TreeNode & trFunction);
	void SetParaValues(const string & strValues, TreeNode & trFunction);

	// Initializations
	string GetBeforeFittingScript(TreeNode & trFunction);
	void SetBeforeFittingScript(const string & strScript, TreeNode & trFunction);

	// After Fitting
	string GetAfterFittingScript(TreeNode & trFunction);
	void SetAfterFittingScript(const string & strScript, TreeNode & trFunction);

	// Independent Variables
	string GetIndependVars(TreeNode & trFunction, char chDelimiter);
	void SetIndependVars(vector<string> & vsIndependVars, TreeNode & trFunction);
	///Jasmine 06/21/10 ORG-343 QUICK_CHECK_FUNCTION_BODY
	string GetIndependVarsWithValue(TreeNode & trFunction, char chDelimiter);
	int ParseIndependVarsValue(vector& vIndepValue, const TreeNode& trFunction, LPCSTR lpczsIndepVal, char chDelimiter);
	///End QUICK_CHECK_FUNCTION_BODY

	// Dependent Variables
	string GetDependVars(TreeNode & trFunction, char chDelimiter);
	void SetDependVars(vector<string> & vsDependVars, TreeNode & trFunction);
	///Jasmine 06/21/10 ORG-343 QUICK_CHECK_FUNCTION_BODY
	string CombineDependVarsWithValue(const vector& vDepValue, const TreeNode& trFunction, char chDelimiter);
	///End QUICK_CHECK_FUNCTION_BODY

	// Formula
	string GetFormula(TreeNode & trFunction);
	bool   SetFormula(const string &  strFormula, TreeNode & trFunction);

	// Initializations
	
	// Controls
	bool IsEnableConstraint(TreeNode & trFunction);
	void EnableConstraint(bool bEnableConstraint, TreeNode & trFunction);

	bool IsAutoInitial(TreeNode & trFunction);
	void SetAutoInitial(bool bAutoInitial, TreeNode & trFunction);

	bool IsPeak(TreeNode & trFunction);
	void SetPeak(bool bPeek, TreeNode & trFunction);
	bool CheckCopyPeakAttributeNodes(bool bPeakFunction, const TreeNode& trSource, TreeNode& trTarget);
	
	TreeNode	GetControls(const TreeNode& trFunction, bool bAddWhenNoExist=true, string strSubNode = "");	

	// Compile Function
	void UpdateCompileState(TreeNode& trFunction);
	bool IsUseOC(TreeNode & trFunction);
	void SetUseOC(bool bUseOC, TreeNode & trFunction);

	// Parameters Initializations
	string GetInitialCode(TreeNode & trFunction);
	void SetInitialCode(const string & strCode, TreeNode & trFunction);
	
	// Derived Parameter Settings
	int GetDerivedParameterSetting(TreeNode & trFunction, vector<string> & vsNames = NULL, vector<string> & vsMeanings = NULL, vector<string> & vsUnit = NULL);
	void SetDerivedParameterSetting(TreeNode & trFunction, vector<string> & vsNames = NULL, vector<string> & vsMeanings = NULL, vector<string> & vsUnit = NULL);

	// Constraints
	string GetConstraints(TreeNode & trFunction);
	void SetConstraints(const string & strConstraints, TreeNode & trFunction);
	
	// Constants
	int  GetConstants(TreeNode & trFunction, vector<string> & vsVariables, vector<string> & vsValues);
	void SetConstants(vector<string> & vsVariables, vector<string> & vsValues, TreeNode & trFunction);

	///------ Folger 06/24/10 ORG-390-P4 SHOW_CONSTANTS_IN_EVALUATION_PAGE
	string	GetConstantsWithValues(TreeNode & trFunction);
	///------ End SHOW_CONSTANTS_IN_EVALUATION_PAGE

	// Derived Parameters
	bool CvtDerivedParameterNames(const TreeNode& trFunction);		///Jasmine 08/17/10 ORG-745-P7 COPY_DERIVED_PARAM_SETTINGS_FROM_EQUATION_FOR_OLD_FDF
	string GetDerivedParameterNames(const TreeNode& trFunction);	
	bool HasDerivedParameters(const TreeNode& trFunction);	///Jasmine 08/18/10 ORG-820-S1 NOT_ALLOW_FINISH_UNTIL_DERIVED_PARAM_CHECK_OK
	string GetDerivedParameterEquation(TreeNode & trFunction);
	void SetDerivedParameterEquation(const string & strEquation, TreeNode & trFunction);

	///Jasmine 06/23/10 ORG-2-S4 FUNCTION_WIZARD_ALLOW_USER_DEFINED_FUNC_CHANGE_FORM
	//limit
	bool	IsSysFunc(const TreeNode& trFunction);
	bool	IsSharedFunc(const TreeNode& trFunction);
	///End FUNCTION_WIZARD_ALLOW_USER_DEFINED_FUNC_CHANGE_FORM

	///------ Folger 06/25/10 ORG-390-P2 SAVE_USER_CHANGED_IN_FIT_FUNCTION_WIZARD_INTO_FDF
	int		GetQuickCheckItems(vector<string>& vsNames, vector<string>& vsValues, TreeNode& trFunction);
	int		SetQuickCheckItems(TreeNode& trFunction, const vector<string>& vsNames, const vector<string>& vsValues);
	BOOL	ClearQuickCheck(TreeNode& trFunction);
	int		SetQuickCheck(TreeNode& trFunction, LPCSTR lpcsz);
	///------ End SAVE_USER_CHANGED_IN_FIT_FUNCTION_WIZARD_INTO_FDF
	
	// Other
	int EquationParse(const string strEquations, char chDelimiter, vector<string> & vVariables, vector<string> & vExpressions);
	string GetTreeNodeString(TreeNode & trNode);

	///------ Folger 06/24/10 ORG-390-P3 FDF_FILE_NAME_SHOULD_UPDATE_AFTER_FUNCTION_NAME_CHANGED
	///Jasmine 08/17/10 ORG-745-P5 SHARE_FO_NAME_CHECKING_CODE
	//bool 	UpdateFuncName(string& strName, TreeNode &trFunction, string *pStrError=NULL, string* pstrFile = NULL);
	bool 	CheckUpdateFuncName(string& strName, TreeNode &trFunction, 
								string *pStrError =NULL, string* pstrFile = NULL,
								bool bUpdate = true);//only check name if false
	///End SHARE_FO_NAME_CHECKING_CODE
	///------ End FDF_FILE_NAME_SHOULD_UPDATE_AFTER_FUNCTION_NAME_CHANGED

	///------ Folger 07/05/10 ORG-478-S1 ERROR_CHECKING_FOR_EXPRESSION_MULTIPLE_DEPENDENTS
	BOOL	IsAllowMultipleDeps(TreeNode& trFunction);
	///------ End ERROR_CHECKING_FOR_EXPRESSION_MULTIPLE_DEPENDENTS

	///------ Folger 06/24/10 ORG-390-P4 SHOW_CONSTANTS_IN_EVALUATION_PAGE
protected:
	int		ParseScriptItems(string str, vector<string> & vVariables, vector<string> & vExpressions);
	string	CombineScriptItems(const vector<string> & vVariables, const vector<string> & vExpressions);
	///------ End SHOW_CONSTANTS_IN_EVALUATION_PAGE

	///------ Folger 06/25/10 ORG-390-P2 SAVE_USER_CHANGED_IN_FIT_FUNCTION_WIZARD_INTO_FDF
	int		SubstituteValuesWithQuickCheck(vector& vValues, const vector<string>& vsNames, TreeNode& trFunction);
	///------ End SAVE_USER_CHANGED_IN_FIT_FUNCTION_WIZARD_INTO_FDF
};

/*------------------------------------------------------------------------------*
 * FFWFunctionOrganizer End 													*
 *------------------------------------------------------------------------------*/

#endif
